#include "AudioStack/SMT/clSrcState_RampUpRequesting.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{

//--- Sub-State: RampUpRequesting ----------------------------------------------------------------------------
void clSrcState_RampUpRequesting::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{

   if (NULL != pclAudioSource)
   {
      // invoke play on MW-interface
      pclAudioSource->vMW_On();
   }
}

void clSrcState_RampUpRequesting::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sat2hi, 12.01.10: go to RampDown2Off to send the Off message to fc_audio, because the playcommand has been send at this point
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
}

void clSrcState_RampUpRequesting::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sat2hi, 12.01.10: go to RampDown2Pause to send the Off message to fc_audio, because the playcommand has been send at this point
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

void clSrcState_RampUpRequesting::vMsg_On(clAudioSource* pclAudioSource, tU32 )
{


   // no state change, just userdefined action for running src
   // This message in this state makes only sense for user defined actions
   // e.g. Tuner-Preset-Actions
   if (NULL != pclAudioSource &&  pclAudioSource->u32GetUserData() != 0)
   {
      pclAudioSource->vMW_On();
   }
}

void clSrcState_RampUpRequesting::vMsg_RequestConfirmed(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampUp(), u32UserData);
}

void clSrcState_RampUpRequesting::vMsg_OnDone(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // in normal flow, the RequestConfirmation is provided first.
   // but e.g. in Simu we skip the RequestConfirmation an go directly to On_Done
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOn(), u32UserData);
}

void clSrcState_RampUpRequesting::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // begin sequence again with init
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

}

